#ifndef _FolderTree_H
#define _FolderTree_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define LOAD_TREE_ITEMS_INCREMENT 10

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class FolderTree {
    public:
        BOOL FolderTree::FolderTreeHandler(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam);
        bool InitFolderTree(HWND hTreeHandle, HWND hButtonHandle, HWND hEditBoxHandle);
        bool UnInitFolderTree(void);
        bool SelectPath(char *szPath);
		BOOL DeleteAllItems(void);

    private:
        char **AlreadyLoaded;

        char gsExtractLocation[255 + 1];

        HIMAGELIST hImageList;

        HWND lhButtonHandle;
        HWND lhEditBoxHandle;
        HWND lhTreeHandle;

        int LoadedItems;
        int MaxLoadedItems;

        bool CreateTreeImageList(void);
        bool FreeAlreadyLoaded(void);
        bool GetDesktopFolderPath(char *Desktop);
        BOOL GetTreeItemText(HTREEITEM htItem, char *outText);
        bool IndexDirectoryForSubItem(HTREEITEM SubLeaf, char *inFolder, bool IndexTwoDeep);
        bool InitAlreadyLoaded(void);
        bool IsAlreadyLoaded(char *inFolder);
        bool PopBrowseTree(void);
        HTREEITEM AddTreeViewItem(HTREEITEM hParent, char *inText, int iImage, int iSelImage);
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

